/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Unlimited Scan 2  (COMI-LX20x ø  A/D ĵ )
/* - Contents: 
/*    α׷ Unlimited Scan 2 õ Լ 뿹 ִ 
/*    Դϴ.  α׷ COMI-LX20x ø  0 ä A/D ĵ
/*    Ͽ FFTó ϰ  κ 1ļ 1 ļ Amplitude
/*    մϴ.
/*
/* - Remarks : 
/*     1.   COMI-LX201 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMILX_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include "ComidasLX.h"

#define DEV_ID	COMI_LX201 // Device ID 

extern void fft(int n, double xRe[], double xIm[],
                double yRe[], double yIm[]);
void GetPrincipalFreq(double *re, double *im, double scan_freq, int data_size, 
					   double *pr_freq, double *pr_amp);
void main (void)
{
	HANDLE hDevice;
	int data_size_sel, data_size, buf_size_gain, channel=0;
	float scan_freq;
	short *pScanBuf;

	/* Load DLL */
	if(!COMILX_LoadDll()){
		exit(0);
	}
	/* Load Device */
	hDevice = COMILX_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		COMILX_UnloadDll(); 
		exit(0);
	}
	// ĵ ļ  Է //
	printf("Enter scan freq (0.1MHz ~ 5MHz) : ");
	scanf("%f", &scan_freq);
	// FFT ó    Է //
	printf("\n<0> 1024");
	printf("\n<1> 2048");
	printf("\n<2> 4096");
	printf("\n<3> 8192");
	printf("\nSelect the data size to process for FFT, 0-3 : ");
	scanf("%d", &data_size_sel);
	switch(data_size_sel){
		case 0: data_size = 1024; break;
		case 1: data_size = 2048; break;
		case 2: data_size = 4096; break;
		case 3: data_size = 8192; break;
	}
	// Scan Buffer Size Gain  => ޴  //
	if(data_size <= 4096) buf_size_gain=1;
	else buf_size_gain=2;

	printf("ƹŰ  FFT ó մϴ.׸ ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();
	// FFT ó   Ҵ //
	double *input_re = new double[data_size]; // FFT Է(Ǽ) : A/D  
	double *input_im = new double[data_size]; // FFT Է() :  0 ó
	memset(input_im, sizeof(double)*data_size, 0);
    double *output_re = new double[data_size]; // FFT (Ǽ)
	double *output_im = new double[data_size]; // FFT ()
	double pr_freq, pr_amp; // 1 ļ  (Amplitude)
	
	/* start unlimited scan */
	double act_freq = COMILX_US2_Start (hDevice, 1, &channel, scan_freq*1000000, buf_size_gain, TRUE);

	while(!kbhit())
	{
		if(COMILX_US2_IsBufFull(hDevice))
		{
			// ĵ ۷κ ͸ ´. ⼭ double  ϰ        //
			// Voltage  ޱ Ͽ COMILX_US2_GetBuffer()ſ COMILX_US2_RetrvChannel() //
			//  Ͽ.                                                              //
			COMILX_US2_RetrvChannel (hDevice, 0, 1, data_size, input_re, VT_DOUBLE);
			// FFT ó //
			fft(data_size, input_re, input_im, output_re, output_im);
			// FFT κ 1 ļ  //
			GetPrincipalFreq(output_re, output_im, act_freq, data_size, &pr_freq, &pr_amp);
			printf(" Principal Freq = %.1f(KHz),  %.1f(dB)\n", pr_freq/1000, pr_amp); 
			COMILX_US2_Resume(hDevice); // Scan 簳Ѵ.
		}
	}
	delete []input_re;
	delete []input_im;
	delete []output_re;
	delete []output_im;
	COMILX_US2_Stop (hDevice, TRUE);
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}


//******************************************************************************
//* GetPrincipalFreq() : FFT  ͷκ 1ļ 1ļ ȣ Amplitude
//*     Ѵ.
//*  Input :
//*   -. re : FFT  Ǽ  迭
//*   -. im : FFT    迭
//*   -. scan_freq : A/D ĵ ļ 
//*   -. data_size : FFT ó   
//*  Output : 
//*   -. pr_freq : 1 ļ (Hz)
//*   -. pr_amp : 1 ļ  Amplitude (dB)
//******************************************************************************
void GetPrincipalFreq(double *re, double *im, double scan_freq, int data_size, 
					   double *pr_freq, double *pr_amp)
{
	double freq, amp, max=-99999999;
	for(int i=1; i<data_size/2; i++)
	{
		freq = (double)i*scan_freq/data_size;
		amp = sqrt(re[i]*re[i] + im[i]*im[i])/((double)data_size/2);
		amp = 20 * log(amp);
		if(amp >= max){
			*pr_freq = freq;
			*pr_amp = amp;
			max = amp;
		}
	}
}
